document.addEventListener("DOMContentLoaded", loadFAQs);

function loadFAQs() {
    fetch("../php/faq.php?action=read")
        .then(response => {
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            if (data.error) {
                console.error("Error fetching FAQs:", data.error);
                return;
            }
            const faqBody = document.getElementById("faq-body");
            faqBody.innerHTML = "";
            data.forEach(faq => {
                const row = document.createElement("tr");

                const questionCell = document.createElement("td");
                questionCell.textContent = faq.question;
                row.appendChild(questionCell);

                const answerCell = document.createElement("td");
                answerCell.textContent = faq.answer;
                row.appendChild(answerCell);

                const optionsCell = document.createElement("td");

                const editButton = document.createElement("button");
                editButton.textContent = "Edit";
                editButton.onclick = () => editFAQ(faq.id, faq.question, faq.answer);

                const deleteButton = document.createElement("button");
                deleteButton.textContent = "Delete";
                deleteButton.onclick = () => deleteFAQ(faq.id);

                optionsCell.appendChild(editButton);
                optionsCell.appendChild(deleteButton);
                row.appendChild(optionsCell);

                faqBody.appendChild(row);
            });
        })
        .catch(error => console.error("Error fetching FAQs:", error));
}

function addNewFAQ() {
    const question = prompt("Enter your question:");
    const answer = prompt("Enter your answer:");
    if (question && answer) {
        fetch("../php/faq.php?action=create", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ question, answer })
        })
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP error! status: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    loadFAQs();
                } else {
                    console.error("Error adding FAQ:", data.error);
                }
            })
            .catch(error => console.error("Error adding FAQ:", error));
    }
}

function editFAQ(id, currentQuestion, currentAnswer) {
    const question = prompt("Edit your question:", currentQuestion);
    const answer = prompt("Edit your answer:", currentAnswer);

    if (question && answer) {
        fetch("../php/faq.php?action=update", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ id, question, answer }) // Send the ID, question, and answer to the server
        })
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP error! status: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    loadFAQs(); // Reload FAQs to reflect the update
                } else {
                    console.error("Error updating FAQ:", data.error || "Unknown error");
                }
            })
            .catch(error => console.error("Error editing FAQ:", error));
    }
}

function deleteFAQ(id) {
    if (confirm("Are you sure you want to delete this FAQ?")) {
        fetch(`../php/faq.php?action=delete&id=${id}`, {
            method: "GET" // DELETE method can also be used, but GET works here as the server uses query params
        })
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP error! status: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    loadFAQs(); // Reload FAQs to reflect the deletion
                } else {
                    console.error("Error deleting FAQ:", data.error || "Unknown error");
                }
            })
            .catch(error => console.error("Error deleting FAQ:", error));
    }
}
